
import gurobi

def solve_smoothie_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="apple_smoothies", lb=0, ub=gurobi.GRB.INFINITY)
    y = model.addVar(name="orange_smoothies", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3.5 * x + 4.5 * y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(6 * x + 5 * y <= 500, name="cutting_machine")
    model.addConstr(3 * x + 2 * y <= 500, name="blending_machine")

    # Optimize the model
    model.optimize()

    # Check if the model is infeasible
    if model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The problem is infeasible")
        return

    # Print the solution
    print("Optimal solution:")
    print(f"Apple smoothies: {x.varValue}")
    print(f"Orange smoothies: {y.varValue}")
    print(f"Max profit: {model.objVal}")

solve_smoothie_problem()
