
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("MedicineDosage")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Klun")
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Tao")

# Set objective function
model.setObjective(2.6 * x + 3.2 * y, GRB.MINIMIZE)

# Add constraints
model.addConstr(1.5 * x + 1.3 * y >= 6, "AX7_requirement")
model.addConstr(1.8 * x + 2 * y >= 8, "BY5_requirement")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Number of Klun pills: {x.x:.2f}")
    print(f"Number of Tao pills: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

