
from gurobipy import *

# Create a new model
m = Model("Medicine_Optimization")

# Define variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Klun_Pills", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="Tao_Pills", lb=0)

# Set the objective function
m.setObjective(2.6*x + 3.2*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.5*x + 1.3*y >= 6, "AX7_Requirement")
m.addConstr(1.8*x + 2*y >= 8, "BY5_Requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Klun Pills: {x.x}, Tao Pills: {y.x}")
    print(f"Total Cost: ${2.6*x.x + 3.2*y.x:.2f}")
else:
    print("No optimal solution found.")
