
import gurobi

def solve_medicine_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    K = model.addVar(name="Klun", lb=0, ub=gurobi.GRB.INFINITY)
    T = model.addVar(name="Tao", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: minimize cost
    model.setObjective(2.6 * K + 3.2 * T, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.5 * K + 1.3 * T >= 6, name="AX7_requirement")
    model.addConstr(1.8 * K + 2 * T >= 8, name="BY5_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objVal:.2f}")
        print(f"Klun pills: {K.varValue:.2f}")
        print(f"Tao pills: {T.varValue:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_medicine_problem()
