
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("concert_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="premium_seats")
y = m.addVar(vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(150*x + 50*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "total_seats")
m.addConstr(x >= 50, "min_premium")
m.addConstr(y >= 3*x, "regular_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal}")
    print(f"Premium Seats: {x.x}")
    print(f"Regular Seats: {y.x}")
else:
    print("Infeasible solution")

