
from gurobipy import *

# Create a model
m = Model("Concert_Seat_Optimization")

# Define variables
P = m.addVar(vtype=GRB.INTEGER, name="Premium_Seats", lb=0)
R = m.addVar(vtype=GRB.INTEGER, name="Regular_Seats", lb=0)

# Constraints
m.addConstr(P + R == 300, "Total_Seats")
m.addConstr(P >= 50, "Minimum_Premium_Seats")
m.addConstr(R >= 3*P, "Preference_For_Regular_Seats")

# Objective function: Maximize profit
m.setObjective(150*P + 50*R, GRB.MAXIMIZE)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium Seats: {P.x}")
    print(f"Regular Seats: {R.x}")
    print(f"Maximum Profit: ${150*P.x + 50*R.x}")
else:
    print("No optimal solution found")

