
import gurobi

def solve_concert_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(lb=0, name="Premium_Seats")
    R = model.addVar(lb=0, name="Regular_Seats")

    # Objective function: Maximize profit
    model.setObjective(150 * P + 50 * R, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(P + R <= 300, name="Total_Seats")
    model.addConstr(P >= 50, name="Min_Premium_Seats")
    model.addConstr(R >= 3 * P, name="Preference_Regular_Seats")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Premium Seats = {P.varValue}, Regular Seats = {R.varValue}")
        print(f"Maximum Profit: ${150 * P.varValue + 50 * R.varValue}")
    else:
        print("No optimal solution found.")

solve_concert_seating_problem()
