
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("electronics_inventory")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="headsets") # headsets
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="keyboards") # keyboards

# Set objective function
model.setObjective(80*x + 50*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(2.5*x + 1.5*y <= 200, "space_constraint")
model.addConstr(3*y >= 7*x, "keyboard_proportion")
model.addConstr(200*x + 110*y <= 10000, "budget_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Headsets (x): {x.x}")
    print(f"Number of Keyboards (y): {y.x}")
    print(f"Optimal Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

