
from gurobipy import *

# Create a model
m = Model("Electronics_Store_Profit")

# Define decision variables
H = m.addVar(vtype=GRB.INTEGER, name="Headsets")
K = m.addVar(vtype=GRB.INTEGER, name="Keyboards")

# Set the objective function
m.setObjective(80*H + 50*K, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*H + 1.5*K <= 200, "Floor_Space")
m.addConstr(K >= (7/3)*H, "Keyboard_Requirement")
m.addConstr(200*H + 110*K <= 10000, "Budget")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Headsets: {H.x}")
    print(f"Keyboards: {K.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found.")

