
import gurobi

def solve_inventory_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    H = model.addVar(lb=0, name="Headsets")
    K = model.addVar(lb=0, name="Keyboards")

    # Objective function: Maximize profit
    model.setObjective(80 * H + 50 * K, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2.5 * H + 1.5 * K <= 200, name="FloorSpace")
    model.addConstr(K >= (7/3) * H, name="KeyboardPercentage")
    model.addConstr(200 * H + 110 * K <= 10000, name="Budget")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Headsets = {H.varValue}, Keyboards = {K.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_inventory_problem()
