
import gurobipy as gp

# Create a new model
model = gp.Model("sandwich_optimization")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="large_sandwiches")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="small_sandwiches")

# Set objective function
model.setObjective(5*x + 3.5*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4*x + 3*y <= 1000, "prep_time")
model.addConstr(5*x + 4*y <= 1200, "toast_time")
model.addConstr(x >= 0, "x_nonneg")
model.addConstr(y >= 0, "y_nonneg")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of large sandwiches: {x.x}")
    print(f"Number of small sandwiches: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

