
from gurobipy import *

# Create a model
m = Model("Sandwich_Optimization")

# Define variables
L = m.addVar(vtype=GRB.CONTINUOUS, name="Large_Sandwiches", lb=0)
S = m.addVar(vtype=GRB.CONTINUOUS, name="Small_Sandwiches", lb=0)

# Set objective function
m.setObjective(5*L + 3.50*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*L + 3*S <= 1000, name="Preparation_Time")
m.addConstr(5*L + 4*S <= 1200, name="Toasting_Time")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of Large Sandwiches: {L.x}")
    print(f"Number of Small Sandwiches: {S.x}")
    print(f"Maximum Profit: ${5*L.x + 3.50*S.x:.2f}")
else:
    print("No optimal solution found")
