
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
L = model.addVar(lb=0, name="Large_Sandwiches")
S = model.addVar(lb=0, name="Small_Sandwiches")

# Objective function: Maximize profit
model.setObjective(5*L + 3.5*S, gurobi.GRB.MAXIMIZE)

# Preparation time constraint
model.addConstr(4*L + 3*S <= 1000, name="Preparation_Time")

# Toasting time constraint
model.addConstr(5*L + 4*S <= 1200, name="Toasting_Time")

# Optimize the model
model.optimize()

# Print the status of the optimization
print("Optimization Status:", model.status)

if model.status == gurobi.GRB.OPTIMAL:
    # Print the optimal values of L and S
    print("Optimal Number of Large Sandwiches:", L.varValue)
    print("Optimal Number of Small Sandwiches:", S.varValue)
    print("Max Profit: $", 5*L.varValue + 3.5*S.varValue)
else:
    print("The model is infeasible or unbounded.")
