
import gurobipy as gp

# Create a new model
model = gp.Model("Electronics_Store")

# Create decision variables
t = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="televisions")
s = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="speakers")

# Set objective function
model.setObjective(400*t + 250*s, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(400*t + 200*s <= 25000, "budget")
model.addConstr(t >= 20, "min_televisions")
model.addConstr(t <= 75, "max_televisions")
model.addConstr(s <= 0.5*t, "speaker_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of televisions to buy and sell: {t.x}")
    print(f"Number of speakers to buy and sell: {s.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

