
from gurobipy import *

# Create a new model
m = Model("Electronics_Store_Profit_Optimization")

# Decision variables
T = m.addVar(name='Televisions', vtype=GRB.CONTINUOUS, lb=20, ub=75)
S = m.addVar(name='Speakers', vtype=GRB.CONTINUOUS)

# Objective function: Maximize profit
m.setObjective(400*T + 250*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(400*T + 200*S <= 25000, name='Budget_Constraint')
m.addConstr(S <= 0.5*T, name='Speaker_Sales_Limit')

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution: Televisions = {T.x}, Speakers = {S.x}")
    print(f"Maximum Profit: {m.ObjVal}")
else:
    print("No optimal solution found")
