
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    T = model.addVar(lb=20, ub=75, vtype=gurobi.GRB.INTEGER, name="Televisions")
    S = model.addVar(vtype=gurobi.GRB.INTEGER, name="Speakers")

    # Objective function: Maximize profit
    model.setObjective(400*T + 250*S, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(400*T + 200*S <= 25000, name="Budget_Constraint")

    # Speaker sales constraint: S <= 0.5T
    model.addConstr(S <= 0.5*T, name="Speaker_Sales_Constraint")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: Televisions = {T.varValue}, Speakers = {S.varValue}")
        print(f"Max Profit: ${400*T.varValue + 250*S.varValue}")
    else:
        print("No optimal solution found")

solve_optimization_problem()
