
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("binder_production")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="one_inch_binders")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="two_inch_binders")

# Set objective function
model.setObjective(1*x + 2*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x >= 60, "demand_one_inch")
model.addConstr(y >= 70, "demand_two_inch")
model.addConstr(x <= 150, "capacity_one_inch")
model.addConstr(y <= 160, "capacity_two_inch")
model.addConstr(x + y >= 200, "total_binders")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of one-inch binders: {x.x}")
    print(f"Number of two-inch binders: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

