
from gurobipy import *

# Create a new model
m = Model("binder_production")

# Define decision variables
x = m.addVar(lb=60, ub=150, vtype=GRB.INTEGER, name="one_inch_binders")
y = m.addVar(lb=70, ub=160, vtype=GRB.INTEGER, name="two_inch_binders")

# Define the objective function: maximize profit
m.setObjective(1*x + 2*y, GRB.MAXIMIZE)

# Add constraint for total binders
m.addConstr(x + y >= 200, "total_binders")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Produce {x.x} one-inch binders")
    print(f"Produce {y.x} two-inch binders")
    print(f"Total profit: ${1*x.x + 2*y.x}")
else:
    print("No optimal solution found")

# Print Gurobi model
m.printStats()
