
import gurobi

def solve_binder_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=150, name="one_inch_binders", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, ub=160, name="two_inch_binders", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 1*x1 + 2*x2
    model.setObjective(1*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 60, name="min_one_inch")
    model.addConstr(x2 >= 70, name="min_two_inch")
    model.addConstr(x1 <= 150, name="max_one_inch")
    model.addConstr(x2 <= 160, name="max_two_inch")
    model.addConstr(x1 + x2 >= 200, name="total_binders")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model did not converge to an optimal solution.")

solve_binder_problem()
