
import gurobipy as gp

# Create a new model
m = gp.Model("gardening_optimization")

# Create decision variables
x = m.addVar(lb=0, name="lettuce_sqft")  # sqft of lettuce
y = m.addVar(lb=0, name="tomatoes_sqft") # sqft of tomatoes

# Set objective function
m.setObjective(2*x + 3*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300, "land_constraint")
m.addConstr(5*x + 7*y <= 255, "bug_spray_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Lettuce: {x.x} sqft")
    print(f"Tomatoes: {y.x} sqft")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

