
from gurobipy import *

# Create a new model
m = Model("Gardener_Problem")

# Define the decision variables
L = m.addVar(lb=0, name="Lettuce")
T = m.addVar(lb=0, name="Tomatoes")

# Set the objective function to maximize profit
m.setObjective(2*L + 3*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(L + T <= 300, name="Space_Constraint")
m.addConstr(5*L + 7*T <= 255, name="Bug_Spray_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal Solution Found:")
    print(f"Lettuce: {L.x} sqft")
    print(f"Tomatoes: {T.x} sqft")
    print(f"Maximum Profit: ${2*L.x + 3*T.x}")
else:
    print("No optimal solution found")

