
import gurobi

def solve_gardening_problem():
    # Create a new model
    model = gurobi.Model()

    # Define decision variables
    L = model.addVar(lb=0, name="Lettuce")
    T = model.addVar(lb=0, name="Tomatoes")

    # Objective function: maximize profit
    model.setObjective(2*L + 3*T, gurobi.GRB.MAXIMIZE)

    # Backyard space constraint
    model.addConstr(L + T <= 300, name="Backyard_Space")

    # Bug spray constraint
    model.addConstr(5*L + 7*T <= 255, name="Bug_Spray")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Lettuce: {L.varValue} sqft")
        print(f"Tomatoes: {T.varValue} sqft")
        print(f"Max Profit: ${2*L.varValue + 3*T.varValue}")
    else:
        print("No optimal solution found.")

solve_gardening_problem()
