
import gurobipy as gp

# Create a new model
model = gp.Model("SpeakerProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="regular_speakers")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="portable_speakers")

# Set objective function
model.setObjective(40 * x + 60 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x <= 120, "team_A_limit")
model.addConstr(y <= 200, "team_B_limit")
model.addConstr(x + y <= 300, "testing_machine_limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Regular Speakers: {x.x}")
    print(f"Portable Speakers: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

