
from gurobipy import *

# Create a model
m = Model("Speaker_Production")

# Define decision variables
R = m.addVar(lb=0, vtype=GRB.INTEGER, name="Regular_Speakers")
P = m.addVar(lb=0, vtype=GRB.INTEGER, name="Portable_Speakers")

# Add constraints
m.addConstr(R <= 120, "Team_A_Constraint")
m.addConstr(P <= 200, "Team_B_Constraint")
m.addConstr(R + P <= 300, "Testing_Machine_Constraint")

# Set objective function
m.setObjective(40*R + 60*P, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Regular Speakers: {R.x}")
    print(f"Portable Speakers: {P.x}")
    print(f"Maximum Profit: ${40*R.x + 60*P.x}")
else:
    print("No optimal solution found")

