
import gurobi

def solve_speaker_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, ub=120, name="Regular_Speakers")
    P = model.addVar(lb=0, ub=200, name="Portable_Speakers")

    # Objective function: Maximize profit
    model.setObjective(40*R + 60*P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R <= 120, name="Team_A_constraint")
    model.addConstr(P <= 200, name="Team_B_constraint")
    model.addConstr(R + P <= 300, name="Testing_Machine_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Number of regular speakers to produce: {R.varValue}")
        print(f"Number of portable speakers to produce: {P.varValue}")
        print(f"Maximum profit: ${40*R.varValue + 60*P.varValue}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_speaker_problem()
