
import gurobipy as gp

# Create a new model
model = gp.Model("PotteryProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="mugs") # Number of mugs
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls") # Number of bowls

# Set objective function
model.setObjective(10*x + 15*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20*x + 30*y <= 1200, "time_constraint")
model.addConstr(x + y <= 50, "material_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of mugs to produce: {x.x}")
    print(f"Number of bowls to produce: {y.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

