
from gurobipy import *

# Create a model
model = Model("Pottery_Profit")

# Define variables
m = model.addVar(vtype=GRB.INTEGER, name="mugs")
b = model.addVar(vtype=GRB.INTEGER, name="bowls")

# Objective function: Maximize profit
model.setObjective(10*m + 15*b, GRB.MAXIMIZE)

# Constraints
model.addConstr(20*m + 30*b <= 1200, name="time_constraint")
model.addConstr(m + b <= 50, name="clay_constraint")

# Non-negativity constraints (not necessary with vtype=GRB.INTEGER but for clarity)
model.addConstr(m >= 0, name="m_non_negative")
model.addConstr(b >= 0, name="b_non_negative")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {int(m.x)} mugs and {int(b.x)} bowls.")
    print(f"Maximum profit: ${10*int(m.x) + 15*int(b.x)}")
else:
    print("No optimal solution found.")

