
import gurobi

def solve_pottery_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(name="Mugs", vtype=gurobi.GRB.INTEGER, lb=0)
    B = model.addVar(name="Bowls", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: Maximize profit
    model.setObjective(10*M + 15*B, gurobi.GRB.MAXIMIZE)

    # Time constraint
    model.addConstr(20*M + 30*B <= 1200, name="Time_Constraint")

    # Clay constraint
    model.addConstr(M + B <= 50, name="Clay_Constraint")

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Mugs = {M.varValue}, Bowls = {B.varValue}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_pottery_problem()
