
import gurobipy as gp

# Create a new model
model = gp.Model("ConstructionProfit")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bulldozers")  # Bulldozers
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="forklifts")  # Forklifts

# Set objective function
model.setObjective(7000 * x + 6000 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 2 * y <= 600, "assembly_line")
model.addConstr(2 * x + 1.5 * y <= 400, "qc_time")
model.addConstr(x >= 0, "bulldozers_non_negative")
model.addConstr(y >= 0, "forklifts_non_negative")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Bulldozers: {x.x}")
    print(f"Number of Forklifts: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

