
from gurobipy import *

# Create a new model
m = Model("Construction_Company")

# Define the decision variables
B = m.addVar(lb=0, vtype=GRB.INTEGER, name="Bulldozers")
F = m.addVar(lb=0, vtype=GRB.INTEGER, name="Forklifts")

# Set the objective function to maximize profit
m.setObjective(7000*B + 6000*F, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*B + 2*F <= 600, name="Assembly_Line_Time")
m.addConstr(2*B + 1.5*F <= 400, name="QC_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of Bulldozers: {B.x}")
    print(f"Number of Forklifts: {F.x}")
    print(f"Maximum Profit: ${7000*B.x + 6000*F.x:.2f}")
else:
    print("No optimal solution found.")
