
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="Bulldozers")
    F = model.addVar(lb=0, vtype=gurobi.GRB.CONTINUOUS, name="Forklifts")

    # Objective function: Maximize profit
    model.setObjective(7000*B + 6000*F, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*B + 2*F <= 600, name="Assembly_Line_Time")
    model.addConstr(2*B + 1.5*F <= 400, name="QC_Time")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Bulldozers: {B.varValue}")
        print(f"Forklifts: {F.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_production_problem()
