
import gurobipy as gp

# Create a new model
model = gp.Model("RacketProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tennis_rackets")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="badminton_rackets")

# Set objective function
model.setObjective(20 * x + 17 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(12 * x + 10 * y <= 3000, "molding_constraint")
model.addConstr(15 * x + 12 * y <= 3500, "stringing_constraint")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Tennis Rackets: {x.x}")
    print(f"Number of Badminton Rackets: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

