
from gurobipy import *

# Create a new model
m = Model("Racket_Production")

# Define the decision variables
T = m.addVar(lb=0, vtype=GRB.INTEGER, name="Tennis_Rackets")
B = m.addVar(lb=0, vtype=GRB.INTEGER, name="Badminton_Rackets")

# Set the objective function: Maximize profit
m.setObjective(20*T + 17*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*T + 10*B <= 3000, name="Molding_Constraint")
m.addConstr(15*T + 12*B <= 3500, name="Stringing_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {T.x} tennis rackets and {B.x} badminton rackets.")
    print(f"Maximum profit: ${20*T.x + 17*B.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")

