
import gurobi as gp

# Create a new model
model = gp.Model("TennisBadmintonProduction")

# Define the decision variables
T = model.addVar(lb=0, name="TennisRackets")
B = model.addVar(lb=0, name="BadmintonRackets")

# Objective function: Maximize profit
model.setObjective(20*T + 17*B, gp.GRB.MAXIMIZE)

# Molding time constraint
model.addConstr(12*T + 10*B <= 3000, name="MoldingConstraint")

# Stringing time constraint
model.addConstr(15*T + 12*B <= 3500, name="StringingConstraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal production levels: Tennis Rackets = {T.varValue}, Badminton Rackets = {B.varValue}")
    print(f"Maximum profit: ${20*T.varValue + 17*B.varValue:.2f}")
else:
    print("The model is infeasible or unbounded.")
