
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("costume_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="police_costumes") # Number of police costumes
y = m.addVar(vtype=GRB.INTEGER, name="fireman_costumes") # Number of fireman costumes


# Set objective function
m.setObjective(10*x + 12*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 12*y <= 3000, "time_constraint")
m.addConstr(y >= 3*x, "demand_constraint")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Police Officer Costumes: {x.x}")
    print(f"Number of Fireman Costumes: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

