
from gurobipy import *

# Create a new model
m = Model("Costume_Problem")

# Define the decision variables
P = m.addVar(vtype=GRB.INTEGER, name="Police_Officer_Costumes")
F = m.addVar(vtype=GRB.INTEGER, name="Fireman_Costumes")

# Set the objective function to maximize profit
m.setObjective(10*P + 12*F, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*P + 12*F <= 3000, "Time_Constraint")
m.addConstr(F >= 3*P, "Ratio_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Police Officer Costumes: {P.x}")
    print(f"Fireman Costumes: {F.x}")
    print(f"Maximum Profit: ${10*P.x + 12*F.x}")
else:
    print("No optimal solution found")
