
import gurobi

def solve_costume_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="Police_Officer_Costumes")
    y = model.addVar(lb=0, name="Fireman_Costumes")

    # Objective function: Maximize profit
    model.setObjective(10*x + 12*y, gurobi.GRB.MAXIMIZE)

    # Time constraint
    model.addConstr(10*x + 12*y <= 3000, name="Time_Constraint")

    # Popularity constraint
    model.addConstr(y >= 3*x, name="Popularity_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Police Officer Costumes: {x.varValue}")
        print(f"Fireman Costumes: {y.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_costume_problem()
