
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Orchard_Optimization")

# Create decision variables
x = m.addVar(lb=0, name="apple_acres")
y = m.addVar(lb=0, name="peach_acres")

# Set objective function
m.setObjective(15*x + 25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 4000, "land_constraint")
m.addConstr(50*x + 80*y <= 30000, "budget_constraint")
m.addConstr(3*x + 5*y <= 600, "maintenance_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of apple trees")
    print(f"Plant {y.x:.2f} acres of peach trees")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

