
from gurobipy import *

# Create a new model
m = Model("Amanda_Tree_Problem")

# Define variables
A = m.addVar(vtype=GRB.CONTINUOUS, name="Apple_Acres", lb=0)
P = m.addVar(vtype=GRB.CONTINUOUS, name="Peach_Acres", lb=0)

# Set the objective function
m.setObjective(15*A + 25*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(A + P <= 4000, "Land_Constraint")
m.addConstr(50*A + 80*P <= 30000, "Budget_Constraint")
m.addConstr(3*A + 5*P <= 600, "Maintenance_Hours_Constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Apple Acres: {A.x}")
    print(f"Peach Acres: {P.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
