
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="apple_acres")
    y = model.addVar(lb=0, name="peach_acres")

    # Objective function: Maximize profit
    model.setObjective(15 * x + 25 * y, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(x + y <= 4000, name="land_constraint")

    # Budget constraint
    model.addConstr(50 * x + 80 * y <= 30000, name="budget_constraint")

    # Maintenance hours constraint
    model.addConstr(3 * x + 5 * y <= 600, name="maintenance_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal acres for apple trees: {x.varValue}")
        print(f"Optimal acres for peach trees: {y.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
