
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_optimization")

# Create decision variables
x = m.addVar(lb=0, name="real_estate")
y = m.addVar(lb=0, name="pharmaceuticals")

# Set objective function
m.setObjective(0.05 * x + 0.10 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 300000, "total_investment")
m.addConstr(x >= 0.30 * 300000, "min_real_estate")
m.addConstr(y <= 0.35 * 300000, "max_pharmaceuticals")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal investment in Real Estate: ${x.x:.2f}")
    print(f"Optimal investment in Pharmaceuticals: ${y.x:.2f}")
    print(f"Maximum return: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

