
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define decision variables
x_r = m.addVar(name="RealEstate_Investment", lb=0)
x_p = m.addVar(name="Pharmaceuticals_Investment", lb=0)

# Objective function: Maximize ROI
m.setObjective(0.05*x_r + 0.10*x_p, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_r + x_p == 300000, name="Total_Investment")
m.addConstr(x_r >= 90000, name="Minimum_RealEstate_Investment")
m.addConstr(x_p <= 105000, name="Maximum_Pharmaceuticals_Investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Real Estate Investment: {x_r.x}")
    print(f"Pharmaceuticals Investment: {x_p.x}")
    print(f"Maximum ROI: {m.objVal}")
else:
    print("No optimal solution found")

