
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="real_estate_investment")
    y = model.addVar(name="pharmaceuticals_investment")

    # Objective function: Maximize return on investment
    model.setObjective(0.05 * x + 0.10 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 300000, name="total_investment")
    model.addConstr(x >= 0.30 * 300000, name="min_real_estate_investment")
    model.addConstr(y <= 0.35 * 300000, name="max_pharmaceuticals_investment")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in real estate: ${x.varValue:.2f}")
        print(f"Optimal investment in pharmaceuticals: ${y.varValue:.2f}")
        print(f"Max return on investment: ${0.05 * x.varValue + 0.10 * y.varValue:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
