
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Jamie's Diet")

# Create variables
x = m.addVar(nonnegative=True, name="chicken") # units of chicken
y = m.addVar(nonnegative=True, name="beef") # units of beef

# Set objective function
m.setObjective(3.4 * x + 7.5 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(10 * x + 30 * y >= 100, "protein_req")
m.addConstr(6 * x + 40 * y >= 60, "fat_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Chicken units: {x.x:.2f}")
    print(f"Beef units: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

