
from gurobipy import *

# Create a new model
m = Model("Jamie_Diet")

# Define the decision variables
x_c = m.addVar(name="chicken", vtype=GRB.CONTINUOUS, lb=0)
x_b = m.addVar(name="beef", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(3.4*x_c + 7.5*x_b, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x_c + 30*x_b >= 100, name="protein_constraint")
m.addConstr(6*x_c + 40*x_b >= 60, name="fat_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Chicken: {x_c.x}")
    print(f"Beef: {x_b.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
