
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(name="chicken", lb=0, ub=gurobi.GRB.INFINITY)
y = model.addVar(name="beef", lb=0, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(3.4 * x + 7.5 * y, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(10 * x + 30 * y >= 100, name="protein_requirement")
model.addConstr(6 * x + 40 * y >= 60, name="fat_requirement")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chicken: {x.varValue} units")
    print(f"Beef: {y.varValue} units")
    print(f"Minimum cost: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
