
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("webcam_optimization")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="standard_def") # Number of standard definition webcams
y = m.addVar(vtype=GRB.INTEGER, name="high_def") # Number of high definition webcams

# Set objective function
m.setObjective(100*x + 125*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150*x + 250*y <= 40000, "budget_constraint")
m.addConstr(x + y <= 275, "demand_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Standard Definition Webcams: {x.x}")
    print(f"Number of High Definition Webcams: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

