
from gurobipy import *

# Create a new model
m = Model("WebCam_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.INTEGER, name="Standard_Definition_WebCams")
y = m.addVar(vtype=GRB.INTEGER, name="High_Definition_WebCams")

# Set the objective function to maximize profit
m.setObjective(100*x + 125*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(150*x + 250*y <= 40000, "Total_Cost_Constraint")
m.addConstr(x + y <= 275, "Demand_Constraint")
m.addConstr(x >= 0, "Non_Negativity_Constraint_x")
m.addConstr(y >= 0, "Non_Negativity_Constraint_y")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Standard Definition WebCams: {x.x}")
    print(f"High Definition WebCams: {y.x}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
