
import gurobi

def optimize_web_cam_inventory():
    # Create a new model
    model = gurobi.Model()

    # Define variables: number of SD and HD web-cams
    x = model.addVar(name="SD_web_cams", lb=0, vtype=gurobi.GRB.INTEGER)
    y = model.addVar(name="HD_web_cams", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(100*x + 125*y, gurobi.GRB.MAXIMIZE)

    # Investment constraint
    model.addConstr(150*x + 250*y <= 40000, name="investment_constraint")

    # Demand constraint
    model.addConstr(x + y <= 275, name="demand_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: SD web-cams = {x.varValue}, HD web-cams = {y.varValue}")
        print(f"Max Profit: ${model.objVal}")
    else:
        print("No optimal solution found")

optimize_web_cam_inventory()
