
import gurobipy as gp

# Create a new model
m = gp.Model("Hostel Room Optimization")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="heated_rooms")
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="unheated_rooms")

# Set objective function
m.setObjective(50*x + 35*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 40, "total_rooms")
m.addConstr(x >= 15, "min_heated")
m.addConstr(y >= 4*x, "preference_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of heated rooms (x): {x.x}")
    print(f"Number of unheated rooms (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

